// Borland C++ Builder
// Copyright (c) 1995, 2002 by Borland Software Corporation
// All rights reserved

// (DO NOT EDIT: machine generated header) 'ZylGPSReceiver.pas' rev: 6.00

#ifndef ZylGPSReceiverHPP
#define ZylGPSReceiverHPP

#pragma delphiheader begin
#pragma option push -w-
#pragma option push -Vx
#include <DateUtils.hpp>	// Pascal unit
#include <Controls.hpp>	// Pascal unit
#include <Forms.hpp>	// Pascal unit
#include <Dialogs.hpp>	// Pascal unit
#include <Registry.hpp>	// Pascal unit
#include <Math.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <SysUtils.hpp>	// Pascal unit
#include <ZylCustomGPSReceiver.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Zylgpsreceiver
{
//-- type declarations -------------------------------------------------------
#pragma option push -b-
enum TCommPort { spNone, spCOM1, spCOM2, spCOM3, spCOM4, spCOM5, spCOM6, spCOM7, spCOM8, spCOM9, spCOM10, spCOM11, spCOM12, spCOM13, spCOM14, spCOM15, spCOM16, spCOM17, spCOM18, spCOM19, spCOM20, spCOM21, spCOM22, spCOM23, spCOM24, spCOM25, spCOM26, spCOM27, spCOM28, spCOM29, spCOM30, spCOM31, spCOM32, spCOM33, spCOM34, spCOM35, spCOM36, spCOM37, spCOM38, spCOM39, spCOM40, spCOM41, spCOM42, spCOM43, spCOM44, spCOM45, spCOM46, spCOM47, spCOM48, spCOM49, spCOM50 };
#pragma option pop

typedef Set<TCommPort, spNone, spCOM50>  TCommPortSet;

#pragma option push -b-
enum TBaudRate { br000110, br000300, br000600, br001200, br002400, br004800, br009600, br014400, br019200, br038400, br056000, br057600, br115200, br128000, br256000 };
#pragma option pop

#pragma option push -b-
enum TStopBits { sb1Bit, sb1_5Bits, sb2Bits };
#pragma option pop

#pragma option push -b-
enum TDataWidth { dw5Bits, dw6Bits, dw7Bits, dw8Bits };
#pragma option pop

#pragma option push -b-
enum TParityBits { pbNone, pbOdd, pbEven, pbMark, pbSpace };
#pragma option pop

typedef void __fastcall (__closure *TConnectEvent)(System::TObject* Sender, TCommPort Port);

class DELPHICLASS TZylGPSReceiver;
class PASCALIMPLEMENTATION TZylGPSReceiver : public Zylcustomgpsreceiver::TZylCustomGPSReceiver 
{
	typedef Zylcustomgpsreceiver::TZylCustomGPSReceiver inherited;
	
private:
	AnsiString FPort;
	int FBaudRate;
	Byte FDataWidth;
	Byte FParity;
	Byte FStopBits;
	bool FEnableDTROnOpen;
	bool FEnableRTSOnOpen;
	Classes::TThreadPriority FPriority;
	AnsiString FBuffer;
	Classes::TThread* ComThread;
	int FDelay;
	bool FNeedSynchronization;
	TCommPort ConnectedTo;
	TConnectEvent FOnConnect;
	TConnectEvent FOnDisconnect;
	TCommPort __fastcall GetCommPort(void);
	void __fastcall SetCommPort(TCommPort Value);
	TBaudRate __fastcall GetBaudRate(void);
	void __fastcall SetBaudRate(TBaudRate Value);
	TDataWidth __fastcall GetDataWidth(void);
	void __fastcall SetDataWidth(TDataWidth Value);
	TStopBits __fastcall GetStopBits(void);
	void __fastcall SetStopBits(TStopBits Value);
	TParityBits __fastcall GetParity(void);
	void __fastcall SetParity(TParityBits Value);
	void __fastcall SetEnableDTROnOpen(bool Value);
	void __fastcall SetEnableRTSOnOpen(bool Value);
	bool __fastcall SetDCBState(unsigned ComDevice);
	void __fastcall SetPriority(Classes::TThreadPriority Value);
	AnsiString __fastcall MaxLenStr(AnsiString s, int MaxLen, char c);
	
public:
	__property bool NeedSynchronization = {read=FNeedSynchronization, write=FNeedSynchronization, default=1};
	__fastcall virtual TZylGPSReceiver(Classes::TComponent* AOwner);
	__fastcall virtual ~TZylGPSReceiver(void);
	void __fastcall Open(void);
	void __fastcall Close(void);
	TCommPort __fastcall IsConnected(void);
	TCommPort __fastcall StringToCommPort(AnsiString Port);
	AnsiString __fastcall CommPortToString(TCommPort Port);
	unsigned __fastcall Send(AnsiString str);
	TCommPortSet __fastcall GetExistingCommPorts();
	void __fastcall UploadWaypoint(AnsiString strName, Extended dLatitude, Extended dLongitude);
	void __fastcall UploadRoute(AnsiString strRoute);
	
__published:
	__property TCommPort Port = {read=GetCommPort, write=SetCommPort, default=5};
	__property TBaudRate BaudRate = {read=GetBaudRate, write=SetBaudRate, default=5};
	__property TDataWidth DataWidth = {read=GetDataWidth, write=SetDataWidth, default=3};
	__property TStopBits StopBits = {read=GetStopBits, write=SetStopBits, default=0};
	__property TParityBits Parity = {read=GetParity, write=SetParity, default=0};
	__property bool EnableDTROnOpen = {read=FEnableDTROnOpen, write=SetEnableDTROnOpen, default=1};
	__property bool EnableRTSOnOpen = {read=FEnableRTSOnOpen, write=SetEnableRTSOnOpen, default=1};
	__property Classes::TThreadPriority Priority = {read=FPriority, write=SetPriority, default=3};
	__property ForceCheckSum  = {default=1};
	__property NMEALog  = {default=0};
	__property Commands ;
	__property int Delay = {read=FDelay, write=FDelay, default=1000};
	__property TConnectEvent OnConnect = {read=FOnConnect, write=FOnConnect};
	__property TConnectEvent OnDisconnect = {read=FOnDisconnect, write=FOnDisconnect};
	__property OnReceive ;
	__property OnLatitudeChange ;
	__property OnLongitudeChange ;
	__property OnAltitudeChange ;
	__property OnSpeedChange ;
	__property OnHeadingChange ;
	__property OnPosition2DChange ;
	__property OnPosition3DChange ;
	__property OnSatelliteReceive ;
	__property OnSatellitesReceive ;
	__property OnArrival ;
};


class DELPHICLASS TComThread;
class PASCALIMPLEMENTATION TComThread : public Classes::TThread 
{
	typedef Classes::TThread inherited;
	
private:
	TZylGPSReceiver* Owner;
	unsigned ComDevice;
	
protected:
	void __fastcall DoExecuteReceive(void);
	void __fastcall DoExecuteConnect(void);
	void __fastcall DoExecuteDisconnect(void);
	
public:
	__fastcall TComThread(TZylGPSReceiver* AOwner);
	unsigned __fastcall GetPortHandle(void);
	virtual void __fastcall Execute(void);
	__fastcall virtual ~TComThread(void);
};


typedef TZylGPSReceiver TZylSerialGPSReceiver;
;

//-- var, const, procedure ---------------------------------------------------
static const Shortint dcb_Binary = 0x1;
static const Shortint dcb_ParityCheck = 0x2;
static const Shortint dcb_OutxCtsFlow = 0x4;
static const Shortint dcb_OutxDsrFlow = 0x8;
static const Shortint dcb_DtrControlMask = 0x30;
static const Shortint dcb_DtrControlDisable = 0x0;
static const Shortint dcb_DtrControlEnable = 0x10;
static const Shortint dcb_DtrControlHandshake = 0x20;
static const Shortint dcb_DsrSensivity = 0x40;
static const Byte dcb_TXContinueOnXoff = 0x80;
static const Word dcb_OutX = 0x100;
static const Word dcb_InX = 0x200;
static const Word dcb_ErrorChar = 0x400;
static const Word dcb_NullStrip = 0x800;
static const Word dcb_RtsControlMask = 0x3000;
static const Shortint dcb_RtsControlDisable = 0x0;
static const Word dcb_RtsControlEnable = 0x1000;
static const Word dcb_RtsControlHandshake = 0x2000;
static const Word dcb_RtsControlToggle = 0x3000;
static const Word dcb_AbortOnError = 0x4000;
static const unsigned dcb_Reserveds = 0xffff8000;
extern PACKAGE void __fastcall Register(void);

}	/* namespace Zylgpsreceiver */
using namespace Zylgpsreceiver;
#pragma option pop	// -w-
#pragma option pop	// -Vx

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// ZylGPSReceiver
